/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (23/05/07)
 */   
package com.ejie.p06b.excel;


import java.io.FileOutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.general.P06BConstantes;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BTestExcel implements P06BIExcel {
    private static long numeroEXCEL = 0;
	
	//Todo bien --> Devuelve la ruta donde dejaremos el excel
	//Error --> 1 Error al generar el EXCEL
    public String getEXCEL(HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BTestExcel", "getPDF(...)");
		
		String idioma = (String)request.getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);	
		if (idioma == null || idioma.equals("") ){
			idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
		}
		
		numeroEXCEL=numeroEXCEL+1;
		
		String error="1";
		String excelFichero = P06BParametros.get("excel.testExcel")+numeroEXCEL+".excel";
		P06BLog.send(2,"P06BTestExcel", "excelFichero:"+excelFichero);
		try {
			short rownum;
			//create a new file
			FileOutputStream out = new FileOutputStream(excelFichero);
			//create a new workbook
			HSSFWorkbook wb = new HSSFWorkbook();
			//create a new sheet
			HSSFSheet s = wb.createSheet();
			//declare a row object reference
			HSSFRow r = null;
			//declare a cell object reference
			HSSFCell c = null;
			//create 3 cell styles
			HSSFCellStyle cs = wb.createCellStyle();
			HSSFCellStyle cs2 = wb.createCellStyle();
			HSSFCellStyle cs3 = wb.createCellStyle();
			HSSFDataFormat df = wb.createDataFormat();
			//create 2 fonts objects
			HSSFFont f = wb.createFont();
			HSSFFont f2 = wb.createFont();

			//set font 1 to 12 point type
			f.setFontHeightInPoints((short) 10);
			//make it blue
			f.setColor( (short)0xc );
			//make it bold
			//arial is the default font
			f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

			//set font 2 to 10 point type
			f2.setFontHeightInPoints((short) 9);
			//make it red
			f2.setColor( (short)HSSFFont.COLOR_NORMAL );
			//make it bold
			f2.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
			//Lo tacha
			//f2.setStrikeout( true );

			//set cell stlye
			cs.setFont(f);
			//set the cell format 
			cs.setDataFormat(df.getFormat("#,##0.0"));
			cs.setBorderBottom(HSSFCellStyle.BORDER_MEDIUM);
			//set a thin border
			//cs2.setBorderBottom(cs2.BORDER_MEDIUM);
			
			//fill w fg fill color
			//Fondo negro
			//cs2.setFillPattern((short) HSSFCellStyle.SOLID_FOREGROUND);
			
			//set the cell format to text see HSSFDataFormat for a full list
			cs2.setDataFormat(HSSFDataFormat.getBuiltinFormat("text"));

			//set the font
			cs2.setFont(f2);

			//set the sheet name in Unicode
			if(idioma.equals("es"))
//				wb.setSheetName(0, "Ejemplo Excel", HSSFWorkbook.ENCODING_UTF_16 );
				wb.setSheetName(0, "Ejemplo Excel" );
			else
//				wb.setSheetName(0, "e-Ejemplo Excel", HSSFWorkbook.ENCODING_UTF_16 );
				wb.setSheetName(0, "e-Ejemplo Excel" );
			//in case of compressed Unicode
			//wb.setSheetName(0, "HSSF Test", HSSFWorkbook.ENCODING_COMPRESSED_UNICODE );
			//create a sheet with 30 rows (0-29)
			for (rownum = (short) 0; rownum < 30; rownum++)
			{
			    // create a row
			    r = s.createRow(rownum);
			    // on every other row
			    if ((rownum % 2) == 0)
			    {
			        // make the row height bigger  (in twips - 1/20 of a point)
			        r.setHeight((short) 0x249);
			    }

			    //r.setRowNum(( short ) rownum);
			    // create 10 cells (0-9) (the += 2 becomes apparent later
			    for (int cellnum = 0; cellnum < 6; cellnum += 2)
			    {
			        // create a numeric cell
			        c = r.createCell(cellnum);
			        // do some goofy math to demonstrate decimals
			        c.setCellValue(rownum * 10000 + cellnum
			                + (((double) rownum / 1000)
			                + ((double) cellnum / 10000)));

			        String cellValue;

			        // create a string cell (see why += 2 in the
			        c = r.createCell(cellnum + 1);
			        
			        // on every other row
			        if ((rownum % 2) == 0)
			        {
			            // set this cell to the first cell style we defined
			            c.setCellStyle(cs);
			            // set the cell's string value to "Test"
//adri			            c.setEncoding( HSSFCell.ENCODING_COMPRESSED_UNICODE );
			            if(idioma.equals("es"))
			            	c.setCellValue( "Ejemplo Test " + cellnum+"-"+rownum );
			            else
			            	c.setCellValue( "e-Ejemplo Test" + cellnum+"-"+rownum);
			        }
			        else
			        {
			            c.setCellStyle(cs2);
			            // set the cell's string value to "\u0422\u0435\u0441\u0442"
//adri			            c.setEncoding( HSSFCell.ENCODING_UTF_16 );
			            c.setCellValue( "Especificacin "+ cellnum+"/"+rownum);
			        }


			        // make this column a bit wider
			        s.setColumnWidth(cellnum + 1, (int) ((50 * 8) / ((double) 1 / 20)));
			    }
			}

			//draw a thick black border on the row at the bottom using BLANKS
			//advance 2 rows
			rownum++;
			rownum++;

			r = s.createRow(rownum);

			// define the third style to be the default
			// except with a thick black border at the bottom
			cs3.setBorderBottom(HSSFCellStyle.BORDER_THICK);

			//create 50 cells
			for (int cellnum = 0; cellnum < 50; cellnum++)
			{
			    //create a blank type cell (no value)
			    c = r.createCell(cellnum);
			    // set it to the thick black border style
			    c.setCellStyle(cs3);
			}

			//end draw thick black border


			//demonstrate adding/naming and deleting a sheet
			//create a sheet, set its title then delete it
			s = wb.createSheet();
			wb.setSheetName(1, "DeletedSheet");
			wb.removeSheetAt(1);
			//end deleted sheet
			//write the workbook to the output stream
			//close our file (don't blow out our file handles
			wb.write(out);
			out.close();
			
		}catch( Exception e) {
			P06BLog.send(2,"P06BTestExcel", "Error al generar excel:"+e.getMessage());
			return error;
		}
		return excelFichero;
	}
}